<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddRecurringTaskIdColumnInTasksTable extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('tasks', function (Blueprint $table) {
            $table->integer('recurring_task_id')->unsigned()->nullable()->default(null)->after('created_by');
            $table->foreign('recurring_task_id')->references('id')->on('tasks')->onDelete('set null')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('tasks', function (Blueprint $table) {
            $table->dropForeign(['recurring_task_id']);
            $table->dropColumn(['recurring_task_id']);
        });
    }

}
